/*******************************************************
Filename		:  lu_char_alias.sql
Release 		:  c2.0
SIR			:  1477, 1514
Description		:  Create characteristic alias tables and related objects.
Author			:  Joseph Wilson
Date			:  1/07/2003
                     	   8/01/2003 -- SIR 1514 - Get type category from TSRCALT instead of hardcoding. -C Tsang
                     	   8/26/2003 -- SIR 1514 TIR#1 - Mod to use FK tsrcalt_is_number in TSRCHALS instead of type_name to 
                                  'drive' creation of lu_char_alias and lu_char_alias_type tables. -C Tsang 
			   01/16/04 - SIR 1586 Moved connect string to master install script -JW
Comments		:  
**********************************************************/
spool lu_char_alias.log

drop table lu_char_alias;
drop table lu_char_alias_type;
drop sequence seq_lu_char_alias_type;


create table lu_char_alias unrecoverable 
tablespace storetdata
storage (initial 10M next 10M) 
as
select tsrchals_is_number pk_isn,
	tsrchar_is_number fk_characteristic, 
      tsrcalt_is_number calt_isn,
      name char_alias
from storet.tsrchals ca
where ca.tsrchar_is_number in (select pk_isn from di_characteristic);

commit;

create table lu_char_alias_type
(pk_isn number(12,0),
 tsrcalt_is_number number(12),
 char_alias_type_name varchar2(30) not null,
 char_alias_type_category char(2))
tablespace storetdata
storage (initial 512K next 512K) ;

create sequence seq_lu_char_alias_type
start with 1 increment by 1 nomaxvalue nocycle cache 10;
set serveroutput on
declare
cursor c1 is
select distinct calt_isn
from lu_char_alias;

begin
for c1_var in c1 loop

insert into lu_char_alias_type
(PK_ISN,
 tsrcalt_is_number,
 char_alias_type_name,
 char_alias_type_category)
select seq_lu_char_alias_type.nextval,
       tsrcalt_is_number,
       type_name,
       type_category
from storet.tsrcalt calt
where c1_var.calt_isn = calt.tsrcalt_is_number;
 
end loop;
commit;
end;
/

--create and populate fk in lu_char_alias

alter table lu_char_alias add fk_char_alias_type number(12);

update lu_char_alias ca set fk_char_alias_type = (
	select cat.pk_isn from lu_char_alias_type cat
	where ca.calt_isn = cat.tsrcalt_is_number);
commit;

--drop temporary columns
alter table lu_char_alias drop column calt_isn;
alter table lu_char_alias_type drop column tsrcalt_is_number;

--create indexes
create index char_alias_isd_fk_char on lu_char_alias(fk_characteristic)
tablespace storetindx
storage (initial 3M next 3M);

create bitmap index char_alias_isd_fk_char_type on lu_char_alias(fk_char_alias_type)
tablespace storetindx
storage (initial 3M next 3M);

--create constraints
alter table lu_char_alias_type
add constraint pk_char_alias_type primary key (pk_isn)
using index
tablespace storetindx
storage (initial 1M next 1M);

alter table lu_char_alias
add constraint char_alias_fk_char foreign key (fk_characteristic) 
references di_characteristic(pk_isn);

alter table lu_char_alias
add constraint char_alias_fk_char_type foreign key (fk_char_alias_type) 
references lu_char_alias_type(pk_isn);

alter table lu_char_alias
add constraint pk_char_alias primary key (pk_isn)
using index
tablespace storetindx
storage (initial 1M next 1M);

spool off